## Using Staging Cartman Token Locally
[Cartman Wiki Docs](https://wiki.twitch.com/display/VE/Cartman) from VOD

1. Specify cartman's public key
   *  Change `ECCPublicKeyPath` in [config/development.json](https://git.xarth.tv/cb/dashy/blob/a402a3483b6f101c86b3508538cca8901e24e1a4/config/development.json#L4) from `internal/auth/development_ecc_public.key` to `internal/auth/staging_cartman_public.key`
1. Get an authorized Cartman staging token
   * **Connect to Twitch VPN**
   * `OAuth <token>` from a API call on twitch.tv in request headers
   * `user_id`: your own channel id
   * `channel_id`: some channel id
   * `curl -H "Authorization: OAuth <token>" "http://cartman-staging-elb.dev.us-west2.justin.tv/authorization_token?key=ecc.key&capabilities=dashy::view_stats&user_id=<user_id>&channel_id=<channel_id>"`
     ```
      {
       "token":"<YOUR_CARTMAN_TOKEN>",
       "user_id":"...",
       "client_id":"...",
       "client_row_id":"..."
      }
     ```
1. Include your cartman token in your request headers:
   * `Twitch-Authorization: <YOUR_CARTMAN_TOKEN>`'
     ```
     Example request:
     curl -X GET -H "Twitch-Authorization:<YOUR_CARTMAN_TOKEN>" "http://localhost:8000/v1/stats/channels/104354422/followers?end_time=2019-03-20T06:59:59Z&start_time=2019-01-19T08:00:00Z"
     ```
