package api

import (
	"context"
	"net/http"
	"strconv"

	"code.justin.tv/cb/dashy/internal/clients/sns"
	"code.justin.tv/cb/dashy/internal/httputil"
	"code.justin.tv/cb/dashy/view/layout"
	"code.justin.tv/common/goauthorization"

	log "github.com/sirupsen/logrus"
)

//
// V1
//

// v1Layout returns a user's dashboard layout preferences as a stringified
//	json
func (s *Server) v1Layout(w http.ResponseWriter, req *http.Request) {
	writer := httputil.NewJSONResponseWriter(w)
	channelID := strconv.FormatInt(req.Context().Value(contextKeyChannelID).(int64), 10)

	// Validate authorization pt 2 -- but not anyone should be able to complete
	//	someone else's quest
	token := req.Context().Value(contextKeyTwitchAuthorizationToken).(*goauthorization.AuthorizationToken)
	if token.GetSubject() == channelID {
		go func() {
			message := sns.DashboardAccessMessage{
				ChannelID: channelID,
			}

			err := s.SNS.SendToTopic(context.Background(), message)
			if err != nil {
				log.WithError(err).Error("error: failed to send to dashboard-access sns topic")
			}
		}()
	}

	response := &layout.Response{
		Status: http.StatusOK,
		Config: "",
	}

	writer.OK(response)
}
