package api

import (
	"testing"

	"code.justin.tv/cb/dashy/internal/clients/dynamodb"
	"code.justin.tv/cb/dashy/view/summary"
	"github.com/stretchr/testify/assert"
)

func TestMergeSummaries_NilSummaries(t *testing.T) {
	var sessions []*summary.Session
	var notificationAnalytics []dynamodb.NotificationsAnalytics

	mergeSummaries(sessions, notificationAnalytics)
	assert.Nil(t, sessions)
}

func TestMergeSummaries_EmptyAnalytics(t *testing.T) {
	session := summary.Session{
		ChannelID: 123,
	}
	sessions := []*summary.Session{&session}
	var notificationAnalytics []dynamodb.NotificationsAnalytics

	copy := session
	copy.NotificationAnalytics = map[string]summary.NotificationsAnalytics{}
	expected := []*summary.Session{&copy}

	mergeSummaries(sessions, notificationAnalytics)
	assert.Equal(t, expected, sessions)
}

func TestMergeSummaries_HappyCase(t *testing.T) {
	sessionOne := summary.Session{
		ChannelID:    123,
		BroadcastIDs: []string{"1234"},
	}
	sessionTwo := summary.Session{
		ChannelID:    234,
		BroadcastIDs: []string{"2345"},
	}

	analyticsOne := dynamodb.NotificationsAnalytics{
		ChannelID:         "123",
		BroadcastID:       "1234",
		NotificationCount: 1,
	}

	analyticsTwo := dynamodb.NotificationsAnalytics{
		ChannelID:         "234",
		BroadcastID:       "2345",
		NotificationCount: 2,
	}

	sessions := []*summary.Session{&sessionOne, &sessionTwo}
	notificationAnalytics := []dynamodb.NotificationsAnalytics{analyticsOne, analyticsTwo}

	copyOne := sessionOne
	copyOne.NotificationAnalytics = map[string]summary.NotificationsAnalytics{
		analyticsOne.BroadcastID: {
			ChannelID:         analyticsOne.ChannelID,
			BroadcastID:       analyticsOne.BroadcastID,
			NotificationCount: analyticsOne.NotificationCount,
		},
	}

	copyTwo := sessionTwo
	copyTwo.NotificationAnalytics = map[string]summary.NotificationsAnalytics{
		analyticsTwo.BroadcastID: {
			ChannelID:         analyticsTwo.ChannelID,
			BroadcastID:       analyticsTwo.BroadcastID,
			NotificationCount: analyticsTwo.NotificationCount,
		},
	}
	expected := []*summary.Session{&copyOne, &copyTwo}

	mergeSummaries(sessions, notificationAnalytics)
	assert.Equal(t, expected, sessions)
}
