package api

import (
	"net/http"

	"code.justin.tv/cb/dashy/internal/httputil"
	"code.justin.tv/cb/dashy/view/tagfilters"

	log "github.com/sirupsen/logrus"
)

func (s *Server) v1TagFilters(w http.ResponseWriter, req *http.Request) {
	writer := httputil.NewJSONResponseWriter(w)
	channelID := req.Context().Value(contextKeyChannelID).(int64)

	fetchedTagFilterStat, err := s.DynamoDB.TagFilterStat.GetByChannelID(req.Context(), channelID)

	if err != nil {
		log.WithError(err).Error("Dynamo failed to respond when fetching tag filters data")
		writer.InternalServerError("Failed to fetch  tag filters data", err)
		return
	}

	tags := make([]tagfilters.Tag, len(fetchedTagFilterStat))

	for idx, tag := range fetchedTagFilterStat {
		tags[idx] = tagfilters.Tag{
			TagID:      tag.TagID,
			Percentage: tag.Percentage,
		}
	}

	response := tagfilters.Response{
		Status: http.StatusOK,
		Data: tagfilters.Data{
			ChannelID: channelID,
			Tags:      tags,
		},
	}
	writer.OK(response)
}
