package auth

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestAuth_CanViewStats(t *testing.T) {
	encoder, err := NewEncoder("development_ecc_private.key")
	require.NoError(t, err)
	require.NotNil(t, encoder)

	channelID := "42424242"
	token := encoder.GenerateToken("view_stats", channelID)
	require.NotNil(t, token)

	decoder, err := NewDecoder("development_ecc_public.key")
	require.NoError(t, err)
	require.NotNil(t, decoder)

	err = decoder.CanViewStats(token, channelID)
	assert.NoError(t, err)

	err = decoder.CanViewStats(token, "otherChannelID")
	assert.Error(t, err)
}
