package auth

import (
	"fmt"
	"io/ioutil"

	"code.justin.tv/common/goauthorization"
	"github.com/pkg/errors"
)

// Decoder is a wrapper for goauthorization.Decoder.
type Decoder struct {
	goauthorization.Decoder
}

// NewDecoder instantiates a Decoder.
func NewDecoder(keyPath string) (*Decoder, error) {
	key, err := ioutil.ReadFile(keyPath)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("auth: failed to read file at %s", keyPath))
	}

	decoder, err := goauthorization.NewDecoder(algorithm, audience, issuer, key)
	if err != nil {
		return nil, errors.Wrap(err, "auth: failed to instantiate decoder")
	}

	return &Decoder{decoder}, nil
}

func (decoder *Decoder) CanViewStats(token *goauthorization.AuthorizationToken, channelID string) error {
	claims := goauthorization.CapabilityClaims{
		"view_stats": goauthorization.CapabilityClaim{
			"channel_id": channelID,
		},
	}
	return decoder.Validate(token, claims)
}
