package auth

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestNewDecoder_NoKey(t *testing.T) {
	bogusFilePath := "bogus"

	decoder, err := NewDecoder(bogusFilePath)
	assert.Contains(t, err.Error(), bogusFilePath)
	assert.Nil(t, decoder)
}

func TestNewDecoder_WrongKey(t *testing.T) {
	wrongFilePath := "development_ecc_private.key"

	decoder, err := NewDecoder(wrongFilePath)
	assert.Contains(t, err.Error(), "failed to instantiate decoder")
	assert.Nil(t, decoder)
}

func TestNewDecoder_Success(t *testing.T) {
	filePath := "development_ecc_public.key"

	decoder, err := NewDecoder(filePath)
	assert.NoError(t, err)
	assert.NotNil(t, decoder)
}
