package auth

import (
	"fmt"
	"io/ioutil"
	"time"

	"code.justin.tv/common/goauthorization"
	"github.com/pkg/errors"
)

// Encoder wraps the goauthorization encoder and provides a helper function to
// generate JWTs for local development. This package is not used in production.
type Encoder struct {
	goauthorization.Encoder
}

// NewEncoder makes it easier to create an encoder from a path.
func NewEncoder(keyPath string) (*Encoder, error) {
	key, err := ioutil.ReadFile(keyPath)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("auth: failed to read file at %s", keyPath))
	}

	encoder, err := goauthorization.NewEncoder(algorithm, issuer, key)
	if err != nil {
		return nil, errors.Wrap(err, "auth: failed to instantiate encoder")
	}

	return &Encoder{encoder}, nil
}

// GenerateToken generates a long-lived token that you can use for local
// development.
func (encoder *Encoder) GenerateToken(capability string, channelID string) *goauthorization.AuthorizationToken {
	claim := map[string]goauthorization.CapValue{"channel_id": channelID}
	claims := goauthorization.CapabilityClaims{
		capability: claim,
	}
	token := encoder.Encode(goauthorization.TokenParams{
		Exp:    time.Now().Add(time.Hour * 24 * 365),
		Nbf:    time.Now(),
		Aud:    []string{"code.justin.tv/cb/dashy"},
		Sub:    "does not matter",
		Claims: claims,
	})

	return token
}
