package auth

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestNewEncoder_NoKey(t *testing.T) {
	bogusFilePath := "bogus"

	encoder, err := NewEncoder(bogusFilePath)
	assert.Contains(t, err.Error(), bogusFilePath)
	assert.Nil(t, encoder)
}

func TestNewEncoder_WrongKey(t *testing.T) {
	wrongFilePath := "development_ecc_public.key"

	encoder, err := NewEncoder(wrongFilePath)
	assert.Contains(t, err.Error(), "failed to instantiate encoder")
	assert.Nil(t, encoder)
}

func TestNewEncoder_Success(t *testing.T) {
	filePath := "development_ecc_private.key"

	encoder, err := NewEncoder(filePath)
	assert.NoError(t, err)
	assert.NotNil(t, encoder)
}
