package dashy

import (
	"code.justin.tv/cb/dashy/config"
	"code.justin.tv/cb/dashy/internal/clients/dynamodb"
	"github.com/aws/aws-sdk-go/service/dynamodb/dynamodbiface"
)

type ClientParams struct {
	Region string
	Env    string
}

// NewDynamoDB returns a DynamoDB client connected to Dashy tables
func NewDynamoDB(params *ClientParams) (dynamodbiface.DynamoDBAPI, error) {
	if params.Env == config.Development {
		return dynamodb.NewDynamoDBFromProfile("twitch-dashy-dev", params.Region)
	} else {
		return dynamodb.NewDynamoDBFromEC2Credentials(params.Region)
	}
}
