package dynamodb

import (
	"context"
	"time"
)

const (
	TableStreamSummaryTips      = "StreamSummaryTips"
	TableTagFilters             = "TagFilters"
	TableNotificationsAnalytics = "StreamSummaryNotifications"
)

// Tip
type Tip struct {
	Body string
	URL  string
}

// Tag Filter Stat
type TagFilterStat struct {
	TagID      string
	Percentage float64
}

// Notifications Analytics
type NotificationsAnalytics struct {
	ChannelID          string    `dynamodbav:"channel_id"`
	BroadcastID        string    `dynamodbav:"broadcast_id"`
	StartTime          time.Time `dynamodbav:"stream_start_time,unixtime"`
	FollowerCount      int64     `dynamodbav:"follower_count"`
	EngagementCount    int64     `dynamodbav:"engagement_count"`
	NotificationCount  int64     `dynamodbav:"notification_count"`
	CustomNotification string    `dynamodbav:"custom_notification"`
}

// TipsAdapter
type TipsAdapter interface {
	GetAllByKey(ctx context.Context, language string) ([]Tip, error)
}

// TipsFilterStatAdapter
type TagFilterStatAdapter interface {
	GetByChannelID(ctx context.Context, channelID int64) ([]TagFilterStat, error)
}

// NotificationsAnalyticsAdapter
type NotificationsAnalyticsAdapter interface {
	GetAllByChannelIDAndTime(ctx context.Context, channelID string, startTime, endTime time.Time) ([]NotificationsAnalytics, error)
}
