package users

import (
	"context"

	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/web/users-service/client/usersclient_internal"
	user "code.justin.tv/web/users-service/models"
	"github.com/cactus/go-statsd-client/statsd"
)

// Service is a generic users service interface, to be implemented
// by a specific package (or mock).
type Service interface {
	// GetUserByID calls users service to lookup a user obj for an id
	GetUserByID(ctx context.Context, id string) (*user.Properties, error)
}

type Client struct {
	client usersclient_internal.InternalClient
}

// NewClient instantiates and returns a Client
func NewClient(host string, stats statsd.Statter) (Service, error) {
	conf := twitchclient.ClientConf{
		Host:  host,
		Stats: stats,
	}

	client, err := usersclient_internal.NewClient(conf)
	if err != nil {
		return nil, err
	}

	return &Client{client: client}, nil
}

func (w *Client) GetUserByID(ctx context.Context, id string) (*user.Properties, error) {
	return w.client.GetUserByID(ctx, id, nil)
}
