package zephyr

import (
	"sync"
)

func consolidatePlatforms(platform map[string]int64) map[string]int64 {
	if count, ok := platform["tv"]; ok {
		platform["console"] += count
		delete(platform, "tv")
	}

	if count, ok := platform["desktop_app"]; ok {
		platform["web"] += count
		delete(platform, "desktop_app")
	}

	return platform
}

func fetchOnceStr(fetch func() (string, error)) func() (string, error) {
	var wg sync.WaitGroup
	wg.Add(1)
	var once sync.Once
	var value string
	var err error

	return func() (string, error) {
		once.Do(func() {
			value, err = fetch()
			wg.Done()
		})

		wg.Wait()
		return value, err
	}
}
