package zephyr

import (
	"context"
	"time"

	"code.justin.tv/cb/dashy/view/summary"
)

// Zephyr is the package that interfaces with the dynamo tables written by zephyr
type Zephyr interface {
	GetClipCreatesByTime(ctx context.Context, channelID int64, startTime, endTime time.Time) ([]ClipCreate, error)
	GetClipPlaysByTime(ctx context.Context, channelID int64, startTime, endTime time.Time) ([]ClipPlay, error)
	GetCommercialByTime(ctx context.Context, channelID int64, startTime, endTime time.Time) ([]Commercial, error)
	GetConcurrentViewersByTime(ctx context.Context, channelID int64, startTime, endTime time.Time) ([]ConcurrentViewership, error)
	GetFollowersByTime(ctx context.Context, channelID int64, startTime, endTime time.Time) ([]NewFollower, error)
	GetRaidsByTime(ctx context.Context, channelID int64, startTime, endTime time.Time) ([]Raid, error)
	GetSessionsByTime(ctx context.Context, channelID int64, startTime, endTime time.Time) ([]DynamoSession, error)
	GetSessionsSummaryByTime(ctx context.Context, channelID int64, startTime, endTime time.Time) ([]*summary.Session, error)
	GetSubscriptionPurchaseSuccessByTime(ctx context.Context, channelID int64, startTime, endTime time.Time) ([]SubscriptionPurchase, error)
	GetTotalViews(ctx context.Context, sessions []DynamoSession) (int64, error)
	GetUniqueChattersByTime(ctx context.Context, channelID int64, startTime, endTime time.Time) ([]UniqueChatter, error)
	GetVideoGeoMap(ctx context.Context, sessions []DynamoSession) ([]GeoMap, error)
	GetVideoPlatformsMap(ctx context.Context, sessions []DynamoSession) ([]PlatformMap, error)
	GetVideoReferralMap(ctx context.Context, sessions []DynamoSession) ([]ReferralMap, error)
	GetViewsByTime(ctx context.Context, channelID int64, startTime, endTime time.Time) ([]UniqueView, error)
}
