package legal

// The following thresholds are to satisfy legal requirements.
const (
	minVideoPlaysToShowCountries   = 3
	minVideoPlaysToShowData        = 5
	minVideoPlaysToShowChannelName = 20
	minVideoPlaysToShowPlatforms   = 10
	minVideoPlaysToShowReferrals   = 10
	minCountryCountToShowAll       = 3
)

// DemographicsRevealed is true to reveal any data ONLY IF
// the video play count is at least the minVideoPlaysToShowData,
// otherwise return an empty data set.
func DemographicsRevealed(playCount int64) bool {
	return playCount >= minVideoPlaysToShowData
}

// InvididualCountriesRevealed is true to reveal all countries ONLY IF
// the country count is at least the minCountryCountToShowAll,
// otherwise show only the top country.
func InvididualCountriesRevealed(countryCount int) bool {
	return countryCount >= minCountryCountToShowAll
}

// AnyCountryRevealed is true to reveal the top country ONLY IF
// the video play count is at least the minVideoPlaysToShowCountries,
// otherwise return an empty data set
func AnyCountryRevealed(playCount int64) bool {
	return playCount > minVideoPlaysToShowCountries
}

// IndividualPlatformRevealed is true to reveal any particular platforms ONLY IF
// the video play count is at least the minVideoPlaysToShowPlatforms,
// otherwise merge into "aggregated" platform categories.
func IndividualPlatformRevealed(playCount int64) bool {
	return playCount >= minVideoPlaysToShowPlatforms
}

// IndividualReferralRevealed is true to reveal any particular referral ONLY IF
// the video play count is at least the minVideoPlaysToShowReferrals,
// otherwise merge into "aggregated" internal or external sources.
func IndividualReferralRevealed(playCount int64) bool {
	return playCount >= minVideoPlaysToShowReferrals
}

// ChannelNameRevealed is true to reveal any channel names ONLY IF
// the video play count is at least the minVideoPlaysToShowChannelName,
// otherwise merge all channels into one category.
func ChannelNameRevealed(playCount int64) bool {
	return playCount >= minVideoPlaysToShowChannelName
}
