package set

type int64Set struct {
	hashmap map[int64]struct{}
	setData []int64
}

func NewInt64Set() *int64Set {
	return &int64Set{
		hashmap: map[int64]struct{}{},
		setData: []int64{},
	}
}

func (set *int64Set) Clear() {
	set.hashmap = map[int64]struct{}{}
	set.setData = []int64{}
}

func (set *int64Set) Clone() *int64Set {
	return &int64Set{
		hashmap: set.hashmap,
		setData: set.setData,
	}
}

func (set *int64Set) Length() int {
	return len(set.setData)
}

func (set *int64Set) Items() []int64 {
	return set.setData
}

func (set *int64Set) Add(id int64) bool {
	if _, ok := set.hashmap[id]; !ok {
		set.hashmap[id] = struct{}{}
		set.setData = append(set.setData, id)

		return true
	}

	return false
}

type stringSet struct {
	hashmap map[string]struct{}
	setData []string
}

func NewStringSet() *stringSet {
	return &stringSet{
		hashmap: map[string]struct{}{},
		setData: []string{},
	}
}

func (set *stringSet) Clear() {
	set.hashmap = map[string]struct{}{}
	set.setData = []string{}
}

func (set *stringSet) Clone() *stringSet {
	return &stringSet{
		hashmap: set.hashmap,
		setData: set.setData,
	}
}

func (set *stringSet) Length() int {
	return len(set.setData)
}

func (set *stringSet) Items() []string {
	return set.setData
}

func (set *stringSet) Add(str string) bool {
	if _, ok := set.hashmap[str]; !ok {
		set.hashmap[str] = struct{}{}
		set.setData = append(set.setData, str)

		return true
	}

	return false
}
