def awsAccounts = [
  dev: [
    keyId: 'aws-web-dev-access-key',
    secretId: 'aws-web-dev-secret-key',
    s3Bucket: 'twitch-web-dev'
  ],

  prod: [
    keyId: 'aws-web-prod-access-key',
    secretId: 'aws-web-prod-secret-key',
    s3Bucket: 'twitch-web-aws'
  ]
]

job {
  name 'cb-dashy-build'
  using 'TEMPLATE-autobuild'

  scm {
    git {
      remote {
        github 'cb/dashy', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }

      clean true
    }
  }

  steps {
    shell './_scripts/build_docker.sh \$GIT_COMMIT'
  }
}

awsAccounts.each { accountSuffix, specs ->
  job {
    name "cb-dashy-deploy-${accountSuffix}"
    using 'TEMPLATE-minimal-skadi-deploy'

    scm {
      git {
        remote {
          github 'cb/dashy', 'ssh', 'git.xarth.tv'
          credentials 'git-aws-read-key'
        }

        branches '${GIT_COMMIT}'
        clean true
      }
    }

    wrappers {
      colorizeOutput()

      credentialsBinding {
        string 'AWS_ACCESS_KEY_ID', specs['keyId']
        string 'AWS_SECRET_ACCESS_KEY', specs['secretId']
      }
    }

    steps {
      shell './_scripts/deploy_beanstalk.sh \$GIT_COMMIT \$ENVIRONMENT \$JOB_NAME'
    }
  }
}

def dashyAccounts = [
  dev: 'dashy-deploy-dev-config',
  prod: 'dashy-deploy-prod-config'
]

dashyAccounts.each { accountSuffix, credentialsId ->
  job {
    name "dashy-deploy-${accountSuffix}"
    using 'TEMPLATE-minimal-skadi-deploy'

    scm {
      git {
        remote {
          github 'cb/dashy', 'ssh', 'git.xarth.tv'
          credentials 'git-aws-read-key'
        }

        branches '${GIT_COMMIT}'
        clean true
      }
    }

    wrappers {
      colorizeOutput()
      credentialsBinding {
        file('AWS_CONFIG_FILE', credentialsId)
      }
    }

    steps {
      shell './_scripts/deploy_beanstalk.sh \$GIT_COMMIT \$ENVIRONMENT \$JOB_NAME'
    }
  }
}
