terraform {
  backend "s3" {
    bucket = "twitch-dashy-dev-terraform"
    key    = "dashy.tfstate"
    region = "us-west-2"
  }
}

module "dashy" {
  source = "../modules/dashy"

  environment = "staging"
  aws_profile = "twitch-dashy-dev"

  instance_type = "c4.large"
  asg_max_size  = 4
  asg_min_size  = 2

  science_aws_account_arn = "arn:aws:iam::673385534282:root"
  zephyr_iam_role_arn     = "arn:aws:iam::141429874596:role/ZephyrDynamoDBReadOnlyAccess"

  aws_key_name                            = "twitch-dashy-dev"
  sandstorm_rollbar_token_key             = "creator-experience-engineering/dashy/dev/rollbar-token"
  sandstorm_cartman_key                   = "identity/cartman/development/ecc_public_key"
  sandstorm_role_key                      = "dashy-dev"
  teleport_jumpbox_security_group         = "sg-03290f2213b38bbd5"
  dashboard_access_sns_topic_name         = "twitch-dashy-staging-dashboard-access"
  aws_account_name                        = "twitch-dashy-dev"
  reserved_vpc_cidr                       = "10.206.40.0/22"
  dns_prefix                              = "twitch-dashy-dev-alb"
  account_id                              = 238337881584
  app_name                                = "dashy-alb"
  internal_alb_dns_name                   = "twitch-dashy-dev-alb.us-west-2.elasticbeanstalk.com"
  vpc                                     = "vpc-03b49378214907133"
  subnet_a                                = "subnet-0633093aca9f0dd8d"
  subnet_b                                = "subnet-0ba23f6eaea5ee551"
  subnet_c                                = "subnet-0782065a9a01a5357"
  vpc_endpoint_service_allowed_principals = [
    # twitch-web-dev
    "arn:aws:iam::465369119046:root",
    # twitch-graphql-dev
    "arn:aws:iam::645130450452:root",
    # crsdata (amp)
    "arn:aws:iam::029773783190:root",
    # twitch-visage-dev
    "arn:aws:iam::628671981940:root",
  ]
}

module "pagerduty_development" {
  source = "../modules/pagerduty"

  elastic_beanstalk_environment_load_balancer = "${module.dashy.elastic_beanstalk_environment_load_balancers_alb[0]}"
  elastic_beanstalk_environment_name          = "${module.dashy.elastic_beanstalk_environment_name_alb}"
  pagerduty_alert_url                         = "https://events.pagerduty.com/integration/c96f1b269eea4f578043df445c2651c6/enqueue"
  sns_topic_name                              = "twitch-dashy-dev-pagerduty-alerts"
  enable_paging                               = "false"
}
