resource "aws_elastic_beanstalk_application" "app-alb" {
  name        = "${var.app_name}"
  description = "Serves streamer dashboard stats, feedback, and tips"
}

resource "aws_elastic_beanstalk_environment" "web-alb" {
  name        = "dashy-live"
  application = "${aws_elastic_beanstalk_application.app-alb.name}"

  solution_stack_name = "64bit Amazon Linux 2018.03 v2.14.1 running Docker 18.09.9-ce"
  cname_prefix        = "${var.dns_prefix}"

  setting {
    namespace = "aws:elasticbeanstalk:command"
    name      = "DeploymentPolicy"
    value     = "Rolling"
  }

  setting {
    namespace = "aws:elasticbeanstalk:command"
    name      = "BatchSizeType"
    value     = "Percentage"
  }

  setting {
    namespace = "aws:elasticbeanstalk:command"
    name      = "BatchSize"
    value     = "25"
  }

  setting {
    namespace = "aws:elasticbeanstalk:environment:process:default"
    name      = "HealthCheckPath"
    value     = "/health"
  }

  // Managed updates settings
  setting {
    namespace = "aws:elasticbeanstalk:managedactions"
    name      = "ManagedActionsEnabled"
    value     = "true"
  }

  setting {
    namespace = "aws:elasticbeanstalk:managedactions"
    name      = "PreferredStartTime"
    value     = "Tue:09:00"
  }

  setting {
    namespace = "aws:elasticbeanstalk:managedactions:platformupdate"
    name      = "UpdateLevel"
    value     = "minor"
  }

  setting {
    namespace = "aws:elasticbeanstalk:healthreporting:system"
    name      = "SystemType"
    value     = "enhanced"
  }

  setting {
    namespace = "aws:elasticbeanstalk:healthreporting:system"
    name      = "ConfigDocument"

    value = <<JSON
{
  "CloudWatchMetrics": {
    "Environment": {
      "ApplicationLatencyP90": 60,
      "ApplicationRequests5xx": 60,
      "ApplicationRequestsTotal": 60
    },
    "Instance": {
      "LoadAverage1min": 60,
      "RootFilesystemUtil": 60,
    }
  },
  "Rules": {
    "Environment": {
      "Application": {
        "ApplicationRequests4xx": {
          "Enabled": false
        }
      }
    }
  },
  "Version": 1
}
JSON
  }

  setting {
    namespace = "aws:elasticbeanstalk:environment"
    name      = "ServiceRole"
    value     = "${aws_iam_role.elasticbeanstalk_service_role.name}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:environment"
    name      = "LoadBalancerType"
    value     = "application"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "ENVIRONMENT"
    value     = "${var.environment}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "SANDSTORM_IAM_ROLE_ARN"
    value     = "${var.sandstorm_iam_role_arn_prefix}/${var.sandstorm_role_key}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "SANDSTORM_ROLLBAR_TOKEN_KEY"
    value     = "${var.sandstorm_rollbar_token_key}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "SANDSTORM_CARTMAN_KEY"
    value     = "${var.sandstorm_cartman_key}"
  }

  // Autoscaling Group
  setting {
    namespace = "aws:autoscaling:asg"
    name      = "Availability Zones"
    value     = "Any 2"
  }

  setting {
    namespace = "aws:autoscaling:asg"
    name      = "MinSize"
    value     = "${var.asg_min_size}"
  }

  setting {
    namespace = "aws:autoscaling:asg"
    name      = "MaxSize"
    value     = "${var.asg_max_size}"
  }

  setting {
    namespace = "aws:autoscaling:trigger"
    name      = "MeasureName"
    value     = "CPUUtilization"
  }

  setting {
    namespace = "aws:autoscaling:trigger"
    name      = "LowerThreshold"
    value     = "40"
  }

  setting {
    namespace = "aws:autoscaling:trigger"
    name      = "UpperThreshold"
    value     = "60"
  }

  setting {
    namespace = "aws:autoscaling:trigger"
    name      = "Unit"
    value     = "Percent"
  }

  // Launch configuration
  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "IamInstanceProfile"
    value     = "${aws_iam_instance_profile.app.id}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "SecurityGroups"
    value     = "${aws_default_security_group.default.id}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "EC2KeyName"
    value     = "${var.aws_key_name}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "InstanceType"
    value     = "${var.instance_type}"
  }

  setting {
    namespace = "aws:autoscaling:updatepolicy:rollingupdate"
    name      = "RollingUpdateEnabled"
    value     = "true"
  }

  setting {
    namespace = "aws:autoscaling:updatepolicy:rollingupdate"
    name      = "RollingUpdateType"
    value     = "Health"
  }

  // EC2 VPC
  setting {
    namespace = "aws:ec2:vpc"
    name      = "VPCId"
    value     = "${local.vpc_id}"
  }

  setting {
    namespace = "aws:ec2:vpc"
    name      = "Subnets"
    value     = "${join(",", local.private_subnets)}"
  }

  setting {
    namespace = "aws:ec2:vpc"
    name      = "AssociatePublicIpAddress"
    value     = "false"
  }

  setting {
    namespace = "aws:ec2:vpc"
    name      = "ELBScheme"
    value     = "internal"
  }

  setting {
    namespace = "aws:elasticbeanstalk:cloudwatch:logs"
    name      = "StreamLogs"
    value     = "true"
  }
}

output "elastic_beanstalk_environment_load_balancers_alb" {
  value = "${aws_elastic_beanstalk_environment.web-alb.load_balancers}"
}

output "elastic_beanstalk_environment_name_alb" {
  value = "${aws_elastic_beanstalk_environment.web-alb.name}"
}
