data "aws_iam_policy_document" "app_role_assume_role_policy" {
  statement {
    actions = ["sts:AssumeRole"]
    effect  = "Allow"

    principals {
      type        = "Service"
      identifiers = ["ec2.amazonaws.com"]
    }
  }
}

resource "aws_iam_role" "app" {
  name               = "dashy-ec2-instance-role"
  assume_role_policy = "${data.aws_iam_policy_document.app_role_assume_role_policy.json}"
}

data "aws_iam_policy_document" "elasticbeanstalk_assume_role_policy" {
  statement {
    actions = ["sts:AssumeRole"]
    effect  = "Allow"

    principals {
      type        = "Service"
      identifiers = ["elasticbeanstalk.amazonaws.com"]
    }
  }
}

resource "aws_iam_role" "elasticbeanstalk_service_role" {
  name               = "ElasticBeanstalkServiceRole"
  assume_role_policy = "${data.aws_iam_policy_document.elasticbeanstalk_assume_role_policy.json}"
}

resource "aws_iam_role_policy_attachment" "aws-ebs-service-policy-role-attachment" {
  role       = "${aws_iam_role.elasticbeanstalk_service_role.name}"
  policy_arn = "arn:aws:iam::aws:policy/service-role/AWSElasticBeanstalkService"
}

resource "aws_iam_role_policy_attachment" "aws-ebs-enhanced-health-policy-role-attachment" {
  role       = "${aws_iam_role.elasticbeanstalk_service_role.name}"
  policy_arn = "arn:aws:iam::aws:policy/service-role/AWSElasticBeanstalkEnhancedHealth"
}

resource "aws_iam_instance_profile" "app" {
  name = "${aws_iam_role.app.name}"
  role = "${aws_iam_role.app.name}"
}

# Logs:
data "aws_iam_policy_document" "logs" {
  statement {
    actions = ["logs:*"]
    effect  = "Allow"

    resources = ["arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk/*:log-stream:*"]
  }
}

resource "aws_iam_role_policy" "logs" {
  name   = "logs-policy"
  role   = "${aws_iam_role.app.name}"
  policy = "${data.aws_iam_policy_document.logs.json}"
}

data "aws_iam_policy_document" "cloudwatch_metrics" {
  statement {
    actions = ["cloudwatch:PutMetricData"]
    effect  = "Allow"
    resources = ["*"]
  }
}

resource "aws_iam_role_policy" "cloudwatch_metrics" {
  name   = "cloudwatch-put-metrics-policy"
  role   = "${aws_iam_role.app.name}"
  policy = "${data.aws_iam_policy_document.cloudwatch_metrics.json}"
}

# Sandstorm:
data "aws_iam_policy_document" "sandstorm" {
  statement {
    actions   = ["sts:AssumeRole"]
    effect    = "Allow"
    resources = ["${var.sandstorm_iam_role_arn_prefix}/${var.sandstorm_role_key}"]
  }

  statement {
    actions   = ["s3:GetObject"]
    effect    = "Allow"
    resources = ["arn:aws:s3:::twitch-sandstorm/sandstorm-agent.rpm"]
  }
}

resource "aws_iam_role_policy" "sandstorm" {
  name   = "sandstorm-policy"
  role   = "${aws_iam_role.app.name}"
  policy = "${data.aws_iam_policy_document.sandstorm.json}"
}

# Kinesis Processor DynamoDB tables:
data "aws_iam_policy_document" "dynamodb" {
  statement {
    actions = ["dynamodb:Query"]
    effect  = "Allow"

    resources = [
      "${aws_dynamodb_table.stream-summary-tips.arn}",
      "${aws_dynamodb_table.promotion-results.arn}",
    ]
  }
}

resource "aws_iam_role_policy" "dynamodb" {
  name   = "dynamodb-policy"
  role   = "${aws_iam_role.app.id}"
  policy = "${data.aws_iam_policy_document.dynamodb.json}"
}

# Zephyr DynamoDB tables:
data "aws_iam_policy_document" "assume_zephyr" {
  statement {
    actions   = ["sts:AssumeRole"]
    effect    = "Allow"
    resources = ["${var.zephyr_iam_role_arn}"]
  }
}

resource "aws_iam_role_policy" "assume_zephyr" {
  name   = "assume-zephyr-policy"
  role   = "${aws_iam_role.app.name}"
  policy = "${data.aws_iam_policy_document.assume_zephyr.json}"
}

# DynamoDB Access
data "aws_iam_policy_document" "dynamodb_role_assume_role_policy" {
  statement {
    actions = ["sts:AssumeRole"]
    effect  = "Allow"

    principals {
      type        = "AWS"
      identifiers = ["${var.science_aws_account_arn}"]
    }
  }
}

resource "aws_iam_role" "dynamodb_role" {
  name               = "dashy-dynamodb-access"
  assume_role_policy = "${data.aws_iam_policy_document.dynamodb_role_assume_role_policy.json}"
}

# Jenkins deployment user

resource "aws_iam_user" "deploy" {
  name = "jenkins-deploy-user"
}

resource "aws_iam_user_policy_attachment" "deploy_beanstalk" {
  user       = "${aws_iam_user.deploy.name}"
  policy_arn = "arn:aws:iam::aws:policy/AWSElasticBeanstalkFullAccess"
}

data "aws_iam_policy_document" "dashy_dynamodb_read_only_access_policy" {
  statement {
    actions = ["sts:AssumeRole"]
    effect  = "Allow"

    principals {
      type        = "AWS"
      identifiers = [
        "arn:aws:iam::641044725657:root", # twitch-web-aws
        "arn:aws:iam::465369119046:root", # twitch-web-dev
      ]
    }
  }
}

resource "aws_iam_role" "dashy_dynamodb_read_only_access" {
  name = "DashyDynamoDBReadOnlyAccess"
  assume_role_policy = "${data.aws_iam_policy_document.dashy_dynamodb_read_only_access_policy.json}"
}

resource "aws_iam_role_policy_attachment" "test-attach" {
  role = "${aws_iam_role.dashy_dynamodb_read_only_access.name}"
  policy_arn = "arn:aws:iam::aws:policy/AmazonDynamoDBReadOnlyAccess"
}

# SNS Publish Access
data "aws_iam_policy_document" "any_sns_publish" {
  statement {
    actions = ["SNS:Publish"]
    effect  = "Allow"

    resources = ["*"]
  }
}

resource "aws_iam_role_policy" "sns" {
  name   = "any-sns-publish"
  role   = "${aws_iam_role.app.name}"
  policy = "${data.aws_iam_policy_document.any_sns_publish.json}"
}

# Add roles to access CloudWatch data from Grafana
# Copied from https://wiki.twitch.com/display/SYS/Grafana+-+Adding+New+Cloudwatch+Data+Source

data "aws_iam_policy_document" "grafana-cloudwatch-arp" {
  statement {
    effect = "Allow"
 
    actions = [
      "sts:AssumeRole",
    ]
 
    principals = {
      type = "AWS"
      identifiers = [
        "arn:aws:iam::007917851548:role/grafana-production",
        "arn:aws:iam::386434559102:role/grafana-staging",
      ]
    }
  }
}
resource "aws_iam_role" "grafana-cloudwatch-read-only" {
  name               = "grafana-cloudwatch-read-only"
  assume_role_policy = "${data.aws_iam_policy_document.grafana-cloudwatch-arp.json}"
}
resource "aws_iam_role_policy_attachment" "grafana-cloudwatch-read-only" {
  role       = "${aws_iam_role.grafana-cloudwatch-read-only.name}"
  policy_arn = "arn:aws:iam::aws:policy/CloudWatchReadOnlyAccess"
}
resource "aws_iam_role_policy_attachment" "grafana-ec2-read-only" {
  role       = "${aws_iam_role.grafana-cloudwatch-read-only.name}"
  policy_arn = "arn:aws:iam::aws:policy/AmazonEC2ReadOnlyAccess"
}
