resource "aws_sns_topic" "dashboard_access" {
  name = "${var.dashboard_access_sns_topic_name}"
}

data "aws_iam_policy_document" "dashboard_access_subscription_for_cb_aws" {
  policy_id = "cb_aws_cross_account_policy"

  statement {
    sid = "cb_aws_policy"

    actions = [
      "SNS:Subscribe",
      "SNS:Receive",
    ]

    effect = "Allow"

    principals {
      type        = "AWS"
      identifiers = ["arn:aws:iam::989470033077:root"]
    }

    resources = ["${aws_sns_topic.dashboard_access.arn}"]
  }
}

resource "aws_sns_topic_policy" "dashboard_access_policy" {
  arn    = "${aws_sns_topic.dashboard_access.arn}"
  policy = "${data.aws_iam_policy_document.dashboard_access_subscription_for_cb_aws.json}"
}
