variable "account_id" {
  type        = "string"
  description = "AWS account the PrivateLink should be setup"
}

variable "app_name" {
  type        = "string"
  description = "Application name to create the PrivateLink setup"
}

variable "asg_max_size" {
  type        = "string"
  description = "Largest size a service cluster will grow to"
}

variable "asg_min_size" {
  type        = "string"
  description = "Smallest size a service cluster will shrink down to"
}

variable "aws_key_name" {
  type = "string"
}

variable "aws_profile" {
  type        = "string"
  description = "AWS profile name"
}

variable "aws_region" {
  type    = "string"
  default = "us-west-2"
}

# Historically this value was primarily used to identify and separate different
# stages of resources within the same account. Now it's used only to set the
# Dashy ENVIRONMENT variable.
variable "environment" {
  type        = "string"
  description = "Service environment"
}

variable "instance_type" {
  type        = "string"
  description = "EC2 instance type"
}

variable "internal_alb_dns_name" {
  type        = "string"
  description = "DNS name for the load balancer"
}

variable "name" {
  type        = "string"
  default     = "dashy"
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
}

variable "project" {
  type        = "string"
  default     = "cb/dashy"
  description = "GitHub repository name"
}

variable "root_volume_size" {
  type        = "string"
  default     = 256
  description = "Amount of diskspace allocated to the root drive (GB)"
}

variable "sandstorm_iam_role_arn_prefix" {
  type        = "string"
  default     = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role"
  description = "Prefix to Sandstorm's AWS IAM Role ARN for assuming role"
}

variable "sandstorm_role_key" {
  type        = "string"
  description = "The unique part of the Sandstorm role that must be assumed to read secrets"
}

variable "sandstorm_rollbar_token_key" {
  type        = "string"
  description = "The name of the Sandstorm secrets key that holds the Rollbar api token"
}

variable "sandstorm_cartman_key" {
  type        = "string"
  description = "The name of the Sandstorm secrets key that holds cartman public key"
}

variable "science_aws_account_arn" {
  type        = "string"
  description = "twitch-science-aws account's ID"
}

variable "zephyr_iam_role_arn" {
  type        = "string"
  description = "Zephyr's AWS IAM Role ARN for Dashy to assume role"
}

variable "teleport_jumpbox_security_group" {
  description = "The security group from the offical Teleport Remote jumpbox stack"
}

variable "vpc" {
  type        = "string"
  description = "VPC the PrivateLink should be setup."
}

variable "subnet_a" {
  type        = "string"
  description = "First subnet the PrivateLink should be setup"
}

variable "subnet_b" {
  type        = "string"
  description = "Second subnet the PrivateLink should be setup"
}

variable "subnet_c" {
  type        = "string"
  description = "Third subnet the PrivateLink should be setup"
}

# New whitelist for NLB -> ALB transition
variable "vpc_endpoint_service_allowed_principals" {
  type        = "list"
  description = "The ARNs that are whitelisted to access the VPC endpoint service"
}

# This is a pain to change in Achievements so we specify the topic name to make
# sure it doesn't inadvertantly change.
variable "dashboard_access_sns_topic_name" {
  type        = "string"
  description = "The name of the sns topic that Achievements consumes for the dashboard-access event."
}

# This could be obtained via data.aws_iam_account_alias.current.account_alias but
# we want it to be easy to find where this value is coming from and make it safer
# to change the account alias.
variable "aws_account_name" {
  type        = "string"
  description = "the name of the aws account"
}

variable "reserved_vpc_cidr" {
  description = "Reserved VPC address space for account peering"
}

variable "dns_prefix" {
  type        = "string"
  description = "DNS name prefix"
}
