resource "aws_sns_topic" "pagerduty_alerts" {
  name = "${var.sns_topic_name}"
}

resource "aws_sns_topic_subscription" "pagerduty_alerts_sns" {
  count                  = "${var.enable_paging == "true" ? 1 : 0}"
  topic_arn              = "${aws_sns_topic.pagerduty_alerts.arn}"
  protocol               = "https"
  endpoint               = "${var.pagerduty_alert_url}"
  endpoint_auto_confirms = true
}

