terraform {
  backend "s3" {
    bucket = "twitch-dashy-prod-terraform"
    key    = "dashy.tfstate"
    region = "us-west-2"
  }
}

module "dashy" {
  source = "../modules/dashy"

  environment = "production"
  aws_profile = "twitch-dashy-prod"

  instance_type = "c4.2xlarge"
  asg_max_size  = 8
  asg_min_size  = 4

  science_aws_account_arn = "arn:aws:iam::673385534282:root"
  zephyr_iam_role_arn     = "arn:aws:iam::873624430394:role/ZephyrDynamoDBReadOnlyAccess"

  aws_key_name                            = "twitch-dashy-prod"
  sandstorm_rollbar_token_key             = "creator-experience-engineering/dashy/prod/rollbar-token"
  sandstorm_cartman_key                   = "identity/cartman/production/ecc_public_key"
  sandstorm_role_key                      = "dashy-prod"
  teleport_jumpbox_security_group         = "sg-0a6051a17924dadb3"
  dashboard_access_sns_topic_name         = "twitch-dashy-production-dashboard-access"
  aws_account_name                        = "twitch-dashy-prod"
  reserved_vpc_cidr                       = "10.206.44.0/22"
  dns_prefix                              = "twitch-dashy-prod-alb"
  account_id                              = 381982226559
  app_name                                = "dashy-alb"
  internal_alb_dns_name                   = "twitch-dashy-prod-alb.us-west-2.elasticbeanstalk.com"
  vpc                                     = "vpc-0eb2d35d2203442d8"
  subnet_a                                = "subnet-0cd6cfdbd7edcd4cd"
  subnet_b                                = "subnet-0bb493d8bc513310a"
  subnet_c                                = "subnet-024d565092d919aff"
  vpc_endpoint_service_allowed_principals = [
    # twitch-web-aws
    "arn:aws:iam::641044725657:root",
    # twitch-graphql-prod
    "arn:aws:iam::787149559823:root",
    # crsdata (amp)
    "arn:aws:iam::029773783190:root",
    # twitch-visage-prod
    "arn:aws:iam::736332675735:root",
  ]
}

module "pagerduty_production" {
  source = "../modules/pagerduty"

  elastic_beanstalk_environment_load_balancer = "${module.dashy.elastic_beanstalk_environment_load_balancers_alb[0]}"
  elastic_beanstalk_environment_name          = "${module.dashy.elastic_beanstalk_environment_name_alb}"
  pagerduty_alert_url                         = "https://events.pagerduty.com/integration/c96f1b269eea4f578043df445c2651c6/enqueue"
  sns_topic_name                              = "twitch-dashy-prod-pagerduty-alerts"
  enable_paging                               = "true"
}
