package layout

import (
	"errors"
	"strconv"
)

const (
	ErrorInvalidChannelID     = "Invalid channel id"
	ErrorChannelIDNotParsable = "Channel id not parsable"
)

type Response struct {
	Status  int    `json:"status"`
	Message string `json:"message"`
	Config  string `json:"config"`
}

// GET request for a user's live dashboard layout preferences
type GetV1LayoutPreferencesParams struct {
	ChannelID string
}

// Validate - function checks channel id is parsable and valid
func (params *GetV1LayoutPreferencesParams) Validate() error {
	channelIDInt, err := strconv.Atoi(params.ChannelID)
	if err != nil {
		return errors.New(ErrorChannelIDNotParsable)
	}
	if channelIDInt < 1 {
		return errors.New(ErrorInvalidChannelID)
	}

	return nil
}
