package multichannel

import "time"

// ChatActivitiesResponse is the base payload signature of the
// GET /v1/stats/multi_channel/chat_activities API.
//
// Data is a map of channel ID to a time series of
// concurrent viewer counts.
type ChatActivitiesResponse struct {
	Status int                       `json:"status"`
	Meta   ChatActivitiesMeta        `json:"meta"`
	Data   map[string][]ChatActivity `json:"data"`
}

// ChatActivitiesMeta contains the meta data of the GET Response.
type ChatActivitiesMeta struct {
	StartTime *time.Time `json:"start_time"`
	EndTime   *time.Time `json:"end_time"`
}

// ChatActivity contains the ParticipantCount and MessageCount
// of a given channel at a discrete Timestamp
type ChatActivity struct {
	Timestamp        *time.Time `json:"timestamp"`
	ParticipantCount int64      `json:"participant_count"`
	MessageCount     int64      `json:"message_count"`
}
