package multichannel

import "time"

// CommercialsResponse is the base payload signature of the
// GET /v1/stats/multi_channel/commercials API.
//
// Data is a map of channel ID to the channel's commercial events.
type CommercialsResponse struct {
	Status int                          `json:"status"`
	Meta   CommercialsMeta              `json:"meta"`
	Data   map[string][]CommercialEvent `json:"data"`
}

// CommercialsMeta contains the meta data of the GET Response.
type CommercialsMeta struct {
	StartTime *time.Time `json:"start_time"`
	EndTime   *time.Time `json:"end_time"`
}

// CommercialEvent is an instance of a commercial,
// initiated at Timestamp for the duration of DurationSeconds.
type CommercialEvent struct {
	Timestamp       *time.Time `json:"timestamp"`
	DurationSeconds int64      `json:"duration_seconds"`
}
