package multichannel

import (
	"time"
)

// ConcurrentsResponse is the base payload signature of the
// GET /v1/stats/multi_channel/concurrent_viewers API.
//
// Data is a map of channel ID to a time series of
// concurrent viewer counts.
type ConcurrentsResponse struct {
	Status int                               `json:"status"`
	Meta   ConcurrentsMeta                   `json:"meta"`
	Data   map[string][]ConcurrentViewership `json:"data"`
}

// ConcurrentsMeta contains the meta data of the GET Response.
type ConcurrentsMeta struct {
	StartTime *time.Time `json:"start_time"`
	EndTime   *time.Time `json:"end_time"`
}

// ConcurrentViewership contains the average count of viewers
// concurrently watching a stream at a given timestamp.
type ConcurrentViewership struct {
	Timestamp    *time.Time `json:"timestamp"`
	AverageCount float64    `json:"count"`
}
