package multichannel

import "time"

// FollowsResponse is the base payload signature of the
// GET /v1/stats/multi_channel/follows API.
//
// Data is a map of channel ID to a time series of
// new follows.
type FollowsResponse struct {
	Status int                         `json:"status"`
	Meta   FollowsMeta                 `json:"meta"`
	Data   map[string][]FollowSnapshot `json:"data"`
}

// FollowsMeta contains the meta data of the GET Response.
type FollowsMeta struct {
	StartTime *time.Time `json:"start_time"`
	EndTime   *time.Time `json:"end_time"`
}

// FollowSnapshot is a time-discrete snapshot of the Count
// of follows that occurred at Timestamp.
type FollowSnapshot struct {
	Timestamp *time.Time `json:"timestamp"`
	Count     int64      `json:"count"`
}
