package multichannel

import "time"

// SessionsResponse is the base payload signature of the
// GET /v1/stats/multi_channel/sessions API.
//
// Data is a map of channel ID to a list of sessions
type SessionsResponse struct {
	Status int                  `json:"status"`
	Meta   SessionsMeta         `json:"meta"`
	Data   map[string][]Session `json:"data"`
}

// SessionsMeta contains the meta data of the GET Response.
type SessionsMeta struct {
	StartTime *time.Time `json:"start_time"`
	EndTime   *time.Time `json:"end_time"`
}

// Session is a single stream session.
type Session struct {
	StartTime *time.Time `json:"start_time"`
	EndTime   *time.Time `json:"end_time"`
}
