package multichannel

import "time"

// DemographicsResponse is the base payload signature of the
// GET /v1/stats/multi_channel/video_play_demographics API.
//
// Data is a map of channel ID to the channel's demographics.
type DemographicsResponse struct {
	Status int              `json:"status"`
	Meta   DemographicsMeta `json:"meta"`
	Data   Demographics     `json:"data"`
}

// DemographicsMeta contains the meta data of the GET Response.
type DemographicsMeta struct {
	StartTime *time.Time `json:"start_time"`
	EndTime   *time.Time `json:"end_time"`
}

// Demographics contains a breakdown of geographical, platform, and referrer
// information for all video play events.
//
// Geo and Platform are maps of a source to the count.
type Demographics struct {
	VideoPlayCount int64            `json:"video_play_count"`
	Geo            map[string]int64 `json:"geo"`
	Platform       map[string]int64 `json:"platform"`
	Referrer       Referrer         `json:"referrer"`
}

// Referrer splits video play referral sources between Internal
// (from within the twitch.tv domain) and External.
//
// Internal and External are maps of a source to the count.
type Referrer struct {
	Internal        map[string]int64 `json:"internal"`
	InternalTwitch  map[string]int64 `json:"internal_twitch"`
	InternalChannel map[string]int64 `json:"internal_channel"`
	External        map[string]int64 `json:"external"`
}
