package similarchannel

// GetV1SimilarChannelParams contains the REQUIRED parameters for making a
// GET request for a channel's similar channels score map
type GetV1SimilarChannelParams struct {
	ChannelID string
}

// Response is the base payload signature of the chat API
type Response struct {
	Status  int    `json:"status"`
	Message string `json:"message"`
	Data    Data   `json:"data"`
}

// Data contains the various time series for a channel's similar channels score map
type Data struct {
	Channels []Channels `json:"channels"`
}

type Channels struct {
	ChannelID int64   `json:"channel_id"`
	Score     float64 `json:"score"`
}
