package similargame

// GetV1SimlarGameParams contains the REQUIRED parameters for making a
// GET request for a channel's similar games score map
type GetV1SimilarGameParams struct {
	ChannelID string
}

// Response is the base payload signature of the chat API
type Response struct {
	Status  int    `json:"status"`
	Message string `json:"message"`
	Data    Data   `json:"data"`
}

// Data contains the various time series for a channel's similar game score map
type Data struct {
	Games []Games `json:"games"`
}

type Games struct {
	GameName string  `json:"game_name"`
	Score    float64 `json:"score"`
}
