package stats

import (
	"time"
)

// Response is the base payload signature of the stats APIs.
type Response struct {
	Status  int    `json:"status"`
	Message string `json:"message"`
	Meta    Meta   `json:"meta"`
	Data    Data   `json:"data"`
}

// Meta contains the meta data of the stats response.
//
// While StartTime and EndTime are the filters,
// it is possible for either or both to be null.
//
// SessionGapDurationMinutes is the preconfigured duration
// of the session gap in minutes. When a broadcast ends
// and a subsequent broadcast starts within the configured
// gap duration, the two broadcasts are considered one session.
type Meta struct {
	StartTime                 *time.Time `json:"start_time"`
	EndTime                   *time.Time `json:"end_time"`
	SessionGapDurationMinutes int        `json:"session_gap_duration_minutes"`
	InterpolationChunkMinutes int        `json:"interpolation_chunk_minutes"`
}

// Data contains the various time series data for a channel's statistics.
type Data struct {
	ConcurrentViewers []*ConcurrentViewerCount `json:"concurrent_viewers"`
}

// ConcurrentViewerCount is a time series snapshot of the concurrent viewer
// count at Timestamp.
//
// Count is the average number of users concurrently viewing.
type ConcurrentViewerCount struct {
	Timestamp *time.Time `json:"timestamp"`
	Count     float64    `json:"count"`
}
