package summary

import "time"

// Response is the base payload signature of the sessions APIs.
type Response struct {
	Status   int        `json:"status"`
	Message  string     `json:"message"`
	Meta     Meta       `json:"meta"`
	Sessions []*Session `json:"sessions"`
}

// Meta contains the meta data of the session response.
type Meta struct {
	StartTime *time.Time `json:"start_time"`
	EndTime   *time.Time `json:"end_time"`
}

// Session is a single broadcast session bound by the StartTime and EndTime.
// Each session will have a dynamic number of single key values stored inside
// the Summary map. Collections of data such as arrays or sets will be stored as
// an array of Stat structs inside the Stats map
type Session struct {
	ChannelID             int64                             `json:"-"`
	StartTime             *time.Time                        `json:"start_time"`
	EndTime               *time.Time                        `json:"end_time"`
	SegmentID             string                            `json:"-"`
	IsSegmented           bool                              `json:"-"`
	BroadcastIDs          []string                          `json:"broadcast_ids"`
	Summary               map[string]*string                `json:"summary"`
	Stats                 map[string][]*Stat                `json:"stats"`
	NotificationAnalytics map[string]NotificationsAnalytics `json:"notification_analytics"`
}

// Stat is a simple key value struct used to generate arrays of data sets in
// the Session struct
type Stat struct {
	Key   string `json:"key"`
	Value string `json:"value"`
}

// Notifications Analytics
type NotificationsAnalytics struct {
	ChannelID          string    `json:"channel_id"`
	BroadcastID        string    `json:"broadcast_id"`
	StartTime          time.Time `json:"stream_start_time"`
	FollowerCount      int64     `json:"follower_count"`
	EngagementCount    int64     `json:"engagement_count"`
	NotificationCount  int64     `json:"notification_count"`
	CustomNotification string    `json:"custom_notification"`
}
