provider "aws" {
  region = "us-west-2"
  version = "~> 2.44"
}

module "glue-rds" {
  source = "git::ssh://git@git.xarth.tv/dp/db-s3-glue.git?ref=34c42e16ee804929050832cbfe6bcc967f04c37c"
  database_type = "rds"
  job_name = "blueprint-prod"
  cluster_name = "blueprint-prod"
  tahoe_producer_name = "blueprintdbexport"
  table_config": {
    "operation" = <<EOF
      {
        "worker_count": 2,
        "version": 0,
        "hashfield": "ordering",
        "hashpartitions": 13,
        "spark_optimization": true,
        "schema": [
          {"name": "action_metadata", "type": "string"},
          {"name": "ordering", "type": "int"},
          {"name": "user_name", "type": "string", "sensitivity": "userid"},
          {"name": "ip", "type": "string", "sensitivity": "ip"},
          {"name": "name", "type": "string"},
          {"name": "action", "type": "string"},
          {"name": "event", "type": "string"},
          {"name": "version", "type": "int"},
          {"name": "ts", "type": "timestamp"}
        ]
      }
EOF
    "event_metadata" = <<EOF
      {
        "dpu_count": 4,
        "version": 0,
        "hashexpression": "version",
        "hashpartitions": 29,
        "spark_optimization": true,
        "custom_view_sql_def": "select * from {tahoe_schema}.{tahoe_versioned_name} where user_name is not null",
        "schema": [
          {"name": "metadata_type", "type": "string"},
          {"name": "metadata_value", "type": "string"},
          {"name": "user_name", "type": "string"},
          {"name": "event", "type": "string"},
          {"name": "version", "type": "int"},
          {"name": "ts", "type": "timestamp"}
        ]
      }
EOF
  }

  fail_on_error = 1
  s3_output_bucket = "science-exports"
  s3_output_key = "blueprint-prod"
  s3_script_bucket = "aws-glue-scripts-673385534282-us-west-2"
  error_sns_topic_name = "glue-export-blueprint-prod-error"
  account_number = "673385534282"
  vpc_id = "vpc-0713b162"
  subnet_id = "subnet-0b155927622601a52"
  availability_zone = "us-west-2a"
  rds_subnet_group = "science-prod-databases"
  cluster_username = "scieng_ro"
  db_password_parameter_name = "blueprint-prod-scieng_ro-password"
  db_password_key_id = "6043ca4d-151e-4efb-98da-42d2b661d9fb"
  api_key_parameter_name     = "dbs3gluetest-producer-api-key"
  api_key_kms_key_id         = "6043ca4d-151e-4efb-98da-42d2b661d9fb"
}

output "s3_kms_key" {
  value = module.glue-rds.s3_kms_key
}

output "s3_output_bucket" {
  value = module.glue-rds.s3_output_bucket
}

output "glue_role" {
  value = module.glue-rds.glue_role
}
