// The shape definition override for the glue client in boto3.
// From https://github.com/boto/botocore/blob/master/botocore/data/glue/2017-03-31/service-2.json
data "template_file" "patched_glue_shapes" {
  template = <<END_OF_STRING
{
  "StartJobRunRequest":{
    "type":"structure",
    "required":["JobName"],
    "members":{
      "JobName":{
        "shape":"NameString"
      },
      "JobRunId":{
        "shape":"IdString"
      },
      "Arguments":{
        "shape":"GenericMap"
      },
      "AllocatedCapacity":{
        "shape":"IntegerValue",
        "deprecated":true,
        "deprecatedMessage":"This property is deprecated, use MaxCapacity instead."
      },
      "Timeout":{
        "shape":"Timeout"
      },
      "MaxCapacity":{
        "shape":"NullableDouble"
      },
      "SecurityConfiguration":{
        "shape":"NameString"
      },
      "NotificationProperty":{
        "shape":"NotificationProperty"
      },
      "WorkerType":{
        "shape":"WorkerType"
      },
      "NumberOfWorkers":{
        "shape":"NullableInteger"
      }
    }
  },
  "WorkerType":{
    "type":"string",
    "enum":[
      "Standard",
      "G.1X",
      "G.2X"
    ]
  },
  "NullableInteger":{
    "type":"integer",
    "box":true
  },
  "NullableDouble":{
    "type":"double",
    "box":true
  }
}
END_OF_STRING
}
