# dropship
Quick Action layout and positioning API

[![Build Status](https://jenkins.internal.justin.tv/buildStatus/icon?job=cb-dropship-build)](https://jenkins.internal.justin.tv/job/cb-dropship-build)

[Runbook](/docs/runbook.md) | [SLA](/docs/sla.md) | [Deploying](/docs/deployment.md) | [API](docs/api.md) | [Dashboard](https://grafana.internal.justin.tv/d/xM8jEXDWk/cb-dropship)

The [docs](/docs) folder contains more information about using Dropship.

## Service Links

* AWS Accounts
  * Production/Staging (twitch-cb-aws): [Console](https://twitch-cb-aws.signin.aws.amazon.com/console)
* Service Endpoints
  * Production: http://prod.dropship.cb.twitch.a2z.com
  * Staging: http://staging.dropship.cb.twitch.a2z.com

## Usage
Dropship uses [twirp](https://twitchtv.github.io/twirp/) for client generation. You can use the client like this:

```go
import (
    "context"
    "http"

    "code.justin.tv/cb/dropship/rpc/dropship"
)

client := dropship.NewDropshipProtobufClient("http://localhost:8000", http.DefaultClient)
request := &dropship.GetLayoutReq{
    ChannelID: "123456",
    OwnerID: "123456",
    Cursor: "",
    Limit: 100
}
resp, err := client.GetLayout(context.Background(), request)
...
```

You will need to a private link or a peered connection to the `twitch-cb-aws` account. If you don't currently have one, you can
request a new one in #dashboard-feedback.

Additional API documentation can be found [here](./docs/api.md). You can also check the service definition in the [proto file](./rpc/dropship/service.proto).
Details about Dropship internals can be found [here](./docs/design.md).

## Development
If you have go and homebrew installed, run `make setup` to install project dependencies.

The [makefile](./Makefile) contains some useful commands for development:
1. `make lint`: runs golangci-lint
2. `make test`: runs all unit tests
3. `make run`: starts the dropship server locally
4. `make mocks`: generates test mocks for dependencies
5. `make proto`: generates the twirp service definition

### Dependencies
Dropship relies on the following dependencies. They can be installed individually using `brew install ...`, `go get ...`, or using the `make setup` command.
Using the make command is recommended.
1. `gomock`: unit test mocks
2. `golangci-lint`: lints go code
3. `protoc`: generates protobuf/twirp services
4. `dep`: dependency management
5. `clang-format`: formats `.proto` files
6. `terraform`: infrastructure management
7. `gogoproto`: Extensions for protobuf generation

## Project Design
An overview of the system is described in [design](./docs/design.md).

