package main

import (
	"os"

	"code.justin.tv/cb/dropship/internal/clients/dynamodb"
	"code.justin.tv/cb/dropship/internal/clients/stats"
	"code.justin.tv/cb/dropship/internal/userdestroy"
	"code.justin.tv/cb/dropship/internal/util"
	"code.justin.tv/eventbus/client/subscriber/lambdafunc"
	"code.justin.tv/eventbus/schema/pkg/user"
	"github.com/aws/aws-lambda-go/lambda"

	eventbus "code.justin.tv/eventbus/client"
	log "github.com/sirupsen/logrus"
)

func main() {
	env := os.Getenv("ENVIRONMENT")
	if env == "" {
		log.Fatal("userdestroy: no environment found in env")
		return
	}

	region := os.Getenv("REGION")
	if region == "" {
		log.Fatal("userdestroy: no region found in env")
		return
	}

	dynamoTableName := os.Getenv("LAYOUT_TABLE_NAME")
	if dynamoTableName == "" {
		log.Fatal("userdestroy: no dynamo table name found in env")
		return
	}

	dynamoCredentials := util.GetCredsForEC2(env, region)
	dynamoDBClient, err := dynamodb.NewClient(dynamoTableName, region, dynamoCredentials) // TODO: get table name in config
	if err != nil {
		log.Fatal("userdestroy: failed to create dynamodb client", err)
		return
	}

	statsHost := os.Getenv("STATS_HOST")
	if statsHost == "" {
		log.Fatal("userdestroy: no stats host found in env")
		return
	}

	statsdClient, err := stats.NewClient(statsHost, env)
	if err != nil {
		log.Fatal("userdestroy: could not create statsd client: ", err)
		return
	}

	mux := eventbus.NewMux()
	handler := userdestroy.Handler{
		DynamoDB: dynamoDBClient,
		Statsd:   statsdClient,
	}

	user.RegisterDestroyHandler(mux, handler.Handle)

	lambda.Start(lambdafunc.NewSQS(mux.Dispatcher()))
}
