# Dropship API

Dropship's API is generated by twirp. You can find the service definition [here](https://git-aws.internal.justin.tv/cb/dropship/blob/master/rpc/dropship/service.proto).

## Table of Contents
1. [GetLayout](#getlayout)
2. [SetLayout](#setlayout)

## GetLayout
Returns a layout for a given owner id. The layout consists of an ordered list of quick action types and IDs.
The owner ID refers to the owner of the layout, and the channel ID refers to the channel owner of the stream manager.

Route: `/twirp/code.justin.tv.cb.dropship.Dropship/GetLayout`

### Protobuf
Method | Headers | Body |
-------|---------|------|
POST   | `content-type: application/protobuf` | `ownerID:<string>, channelID:<string>`

Response:
```
message GetLayoutResp {
    string ownerID = 1;
    string channelID = 2;
    repeated Item layout = 3;
}

message Item {
    string type = 1;
    string name = 2;
    string ID = 3;
    repeated string IDs = 4;
}
```

### JSON

Method | Headers | Body |
-------|---------|------|
POST   | `content-type: application/json` | `{ "ownerID: "<string>", channelID": "<string>" }`

Request:
```
{
    "channelID": "123456",
    "ownerID": "123456"
}
```

Response:
```
{
    "ownerID": "123456",
    "channelID": "123456",
    "layoutID": "49132907-3a5c-470d-a7c0-d2445eb1d3a8",
    "layout": [
        {
            "type": "quick_action",
            "ID": "edit_stream_info"
        },
        {
            "type": "quick_action",
            "ID": "clip_that"
        },
        {
            "type": "quick_action",
            "ID": "raid_channel"
        }
    ]
}
```


## SetLayout
Sets the layout for a given owner ID and channel ID, and list of quick actions. This sets the entire layout, so any items
missing from the existing layout will be removed if they are not in the input list.

Route: `/twirp/code.justin.tv.cb.dropship.Dropship/SetLayout`

### Protobuf
Method | Headers | Body |
-------|---------|------|
POST   | `content-type: application/protobuf` | `ownerID:<string>, channelID:<string>, layout:<repeated>`

Response:
```
message SetLayoutResp {
    string ownerID = 1;
    string channelID = 2;
    repeated Item layout = 3;
}

message Item {
    string type = 1;
    string name = 2;
    string ID = 3;
    repeated string IDs = 4;
}
```

### JSON

Method | Headers | Body |
-------|---------|------|
POST   | `content-type: application/json` | `{ "ownerID":"<string>", "channelID":"<string>", "layout":"<array>" }`

Request:
```
{
    "channelID": "123456",
    "ownerID": "123456",
    "layout": [
        {
            "type": "quick_action",
            "ID": "edit_stream_info"
        },
        {
            "type": "quick_action",
            "ID": "host_channel"
        },
        {
            "type": "folder",
            "name": "folder1",
            "IDs": [
                "edit_stream_info"
            ]
        }
    ]
}
```

Response:
```
{
    "ownerID": "123456",
    "channelID": "123456",
    "layout": [
        {
            "type": "quick_action",
            "ID": "edit_stream_info"
        },
        {
            "type": "quick_action",
            "ID": "host_channel"
        },
        {
            "type": "folder",
            "name": "folder1",
            "IDs": [
                "edit_stream_info"
            ]
        }
    ]
}
```
