# Deployment

All build and deployment jobs via Jenkins are defined in [`jenkins.groovy`](../jenkins.groovy).

Deploying dropship is done through jenkins and [clean-deploy](https://clean-deploy.internal.justin.tv/#/cb/dropship).

1. Create a new branch for a feature in [cb/dropship](https://git-aws.internal.justin.tv/cb/dropship).
2. Create a pull request for your branch. Ask in the slack channel #dashboard-feedback for a review.
3. Deploy your branch to staging using clean-deploy.
4. After your PR is approved, merge your branch to master and deploy, again using clean-deploy.

### Environment

Only the `master` branch is allowed to be deployed to **production** (see [`deploy.json`](../deploy.json)).

## Rolling Back

You can use clean-deploy to rollback your changes if anything breaks. Click the arrow next to the master branch, and select a previous version of the application. Deploy that version to production to rollback a change.
Make sure to make a new pull request to either fix your error, or revert the change. During this time, it's probably a good idea to freeze dropship from any deployments to make sure your broken change is not re-deployed. You can freeze the project from clean-deploy by clicking the `freeze dropship` button in the top right corner.
