# Dropship Design and Internals

## Table of Contents
1. [What Dropship Does](#what-dropship-does)
2. [How Dropship Works](#how-dropship-works)
3. [Architecture](#architecture)
4. [Project Organization](#project-organization)

## What Dropship Does
[Tech Spec](https://docs.google.com/document/d/1Ck6sOUx5YBXUDojq9xtN5GOIHKed5YnnnTMyVRZobdA)

Dropship handles syncing the layout of quick actions on the stream manager page. Because stream manager will be available on multiple platforms
(web, mobile, and desktop through Twitch Studio), it makes sense that the available quick actions and their ordering is kept in sync between
those platforms.  The API provides basic read/write operations to support these features.

### Default Layouts
When a channel does not have a layout defined, Dropship will provide them with one based on some business rules. This ensures that each broadcaster
has a pre-defined layout, even if they have never used quick actions or visited their stream manager page before. The default layout can only be
changed by altering code. The default layout logic can be found in the `internal/quickactions` package.

### Owner IDs and Channel IDs
Dropship supportd the concept of a quick action layout owner. An owner may be different from a channel, in that the owner of a layout does not necessarily
have to be the same as the channel that the layout appears on. This allows for channel moderators or editors (or any other role that can access
a channels stream manager) to have different layouts than the broadcaster themselves. In those cases, moderators can move mod actions closer to the top
of their layout, while broadcasters may want to have different workflows instead.

### Quick Action IDs
Quick actions are currently identified by their name. This serves as a unique identifier, as each available quick action performs a single
focused activity. The IDs are simply strings, and can be changed in the future. There may be a need to provide more detailed identification
of quick actions based on metadata; this can be done by concatenating fields into a custom identifier that is separate from the name of the action.

### Quick Action Types
The Quick Action panel on the stream manager page will support the creation of folders for organizing and storing quick actions. In order to reflect
this in the ordering of actions, a type field is provided in the response to indicate whether or not the item is a quick action or a folder of
quick actions. Depending on the type of the item, certain fields will exist/not exist. For example, a `folder` type has a `name` field and an `IDs` field
thet represents a list of all quick actions contained in the folder. A non-folder quick action does not have a `name` field, and simply contains a
single `ID` field instead of a list of `IDs`

## How Dropship Works
Dropship utilizes a single dynamodb table in order to store layouts. There is a single row per unique combination of owner ID and channel ID.
Those fields represent the hash and range key of the table. The layout itself is stored using a list of maps, to reflect the JSON structure of
the layout. This allows for easier marshaling/unmarshaling, and makes it easy to set the entire layout in a single write.

## Architecture
[Lucidchart](https://www.lucidchart.com/invitations/accept/50886cc7-e9af-42d4-a0eb-f87f7a961292)

![Dropship Architecture](./images/dropship_architecture.png)

## Project Organization
- `cmd`: Contains the entry point for the dropship server.
- `internal/clients`: Clients for dependencies.
- `internal/dropshipserver`: Logic for the API.
- `internal/mocks`: Client mocks generated by `gomock`.
- `internal/quickactions`: Logic for validating names and provide default actions.
- `internal/util`: Health check and credential handling.
- `rpc`: Contains the twirp service definition and protobuf files.
- `scripts`: Build/deploy scripts.
- `terraform:` Infrastructure configuration.
