# Disaster Recovery

## Database recovery in us-west-2

Point-in-time recovery is enabled for dropship's DynamoDB table. This maintains continuous backups that can be restored from at any point in time in the last 35 days. If the table becomes unavailable or loses all data, a new table can be created from backup in the AAWS console, using the following steps (for production):

1. Navigate to the table's [backups tab](https://us-west-2.console.aws.amazon.com/dynamodb/home?region=us-west-2#tables:group=Dropship;selected=dropship-production-quick-actions-layout;tab=backups) in the cb-aws account.
2. Click the `Restore to point-in-time` button.
3. Enter a new table name and choose the restore time. The default time should be the latest restore date.
4. Click the `Restore table` button.
5. Once the table is fully restored, navigate to the [Elastic Beanstalk software configuration page](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/configuration?applicationName=cb-dropship-production&environmentId=e-rz6difwzfp).
6. Under `Environment Properties`, change the value of the `LAYOUT_TABLE_NAME` property to the new table name that was entered in step 3.
7. Apply the new configuration to the environment.
8. Monitor the change from the [Dropship dashboard](https://grafana.internal.justin.tv/d/xM8jEXDWk/cb-dropship?refresh=30s&orgId=1) and ensure that requests are completing successfully.

## Cross region data recovery

Dropship currently does not support [Global Tables](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables_HowItWorks.html) and dynamo streams. Data is not replicated across region. If us-west-2 is unavailable, dropship data will not be available from any other region.
