# Dropship Runbook

This describes the different components of dropship and how they operate.

[twitch-cb-aws account](https://twitch-cb-aws.signin.aws.amazon.com/console)

[Pagerduty](https://twitchoncall.pagerduty.com/services/P651N4E)

[Service Catalog](https://servicecatalog.internal.justin.tv/services/599)

[Github](https://git-aws.internal.justin.tv/cb/dropship)

[clean-deploy](https://clean-deploy.internal.justin.tv/#/cb/dropship)

## Table of Contents
1. [Deploying and Rollbacks](#deploying-and-rollbacks)
2. [Monitoring and Errors](#monitoring-and-errors)
3. [Pagerduty](#pagerduty)
4. [Infrastructure](#infrastructure)
    1. [Terraform](#terraform)
    2. [Elastic Beanstalk](#elastic-beanstalk)
    3. [DynamoDB](#dynamodb)
5. [Past Alarms](#past-alarms)

### Deploying and Rollbacks
See the deployment [docs](/docs/deployment.md) for help with deploying and rolling back.

### Monitoring and Errors
There is a Grafana dashboard [here](https://grafana.internal.justin.tv/d/xM8jEXDWk/cb-dropship).

DynamoDB can also be monitored from the AWS console, in the Metrics tab:

1. [Production/Staging](https://us-west-2.console.aws.amazon.com/dynamodb/home?region=us-west-2#tables:group=Dropship)

Note that you need to request access to the AWS account where the application lives (but grafana should be accessible). For access, ask in #dashboard-feedback on slack
or ping David Horn.

### Pagerduty
[Pagerduty](https://twitchoncall.pagerduty.com/services/P651N4E)
Pagerduty is integrated with Cloudwatch. Pages are sent based on error rates and application health. See [alarms](/docs/alarms.md) for details.

## Infrastructure

### Terraform
Infrastructure configuration is done using terraform. All these files live in the git repo, in the `terraform` folder. Changes should be applied to both staging and production, and committed to the repo using a pull request. If you need assistance with terraform, ask in #dashboard-feedback on slack.

### Elastic Beanstalk
The Dropship API runs in an Elastic Beanstalk environment, inside the twitch-cb-aws account.
1. [Production](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/dashboard?applicationName=cb-dropship-production&environmentId=e-rz6difwzfp)
2. [Staging](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/dashboard?applicationName=cb-dropship-staging&environmentId=e-xu23eit6ui)

### DynamoDB
Dropship stores layouts in a single dynamodb table. For more details on the schema, see the [design](./design.md) docs.
1. [Production](https://us-west-2.console.aws.amazon.com/dynamodb/home?region=us-west-2#tables:group=Dropship;selected=dropship-production-quick-actions-layout;tab=overview)
2. [Staging](https://us-west-2.console.aws.amazon.com/dynamodb/home?region=us-west-2#tables:group=Dropship;selected=dropship-staging-quick-actions-layout;tab=overview)

### Past Alarms
See [alarms](./alarms.md) for details.
