package dynamodb

import "time"

type Layout struct {
	OwnerID     string     `dynamodbav:"owner_id"`
	ChannelID   string     `dynamodbav:"channel_id"`
	LayoutID    string     `dynamodbav:"layout_id"`
	Items       []Position `dynamodbav:"layout"`
	LastUpdated time.Time  `dynamodbav:"last_updated"`
}

type Position struct {
	Type string     `dynamodbav:"type"`
	Name *string    `dynamodbav:"name,omitempty"`
	ID   *string    `dynamodbav:"id,omitempty"`
	IDs  []Position `dynamodbav:"ids,omitempty"`
}
