package ripley

import (
	"context"
	"net/http"

	pb "code.justin.tv/revenue/ripley/rpc"
	log "github.com/sirupsen/logrus"
)

// Payouts is the interface for payout related functions.
type Payouts interface {
	IsPartner(ctx context.Context, channelID string) (bool, error)
}

// Client wraps the ripley protobuf client
type Client struct {
	ripley pb.Ripley
}

// NewClient creates a new ripley client
func NewClient(host string) *Client {
	return &Client{
		ripley: pb.NewRipleyProtobufClient(host, http.DefaultClient),
	}
}

// IsPartner returns true if the provided channelID is a parter, false otherwise
func (c *Client) IsPartner(ctx context.Context, channelID string) (bool, error) {
	req := &pb.GetPayoutTypeRequest{
		ChannelId: channelID,
	}

	resp, err := c.ripley.GetPayoutType(ctx, req)
	if err != nil {
		log.WithField("channel_id", channelID).WithError(err).Error("ripley: failed to get payout status")
		return false, err
	}

	return resp.GetPayoutType().GetIsPartner(), nil
}
