package dropshipserver

import (
	"fmt"
	"strings"

	"github.com/twitchtv/twirp"
)

const errGQLMetaKey = "gql_code"

var (
	ErrMissingChannelID = twirp.RequiredArgumentError("channelID").WithMeta(errGQLMetaKey, "INVALID_CHANNEL_ID")
	ErrMissingOwnerID   = twirp.RequiredArgumentError("ownerID").WithMeta(errGQLMetaKey, "INVALID_OWNER_ID")
	ErrMissingItem      = twirp.RequiredArgumentError("item").WithMeta(errGQLMetaKey, "INVALID_ITEM")
	ErrMissingLayoutID  = twirp.RequiredArgumentError("layoutID").WithMeta(errGQLMetaKey, "INVALID_LAYOUT_ID")
)

// GetErrInvalidQuickActions returns a twirp error indicating that 1 or more provided quick
// action names were invalid.
func GetErrInvalidQuickActions(invalids []string) error {
	invalidStr := strings.Join(invalids, ",")
	msg := fmt.Sprintf("The following quick action names provided do not exist: '%s'", invalidStr)
	return twirp.InvalidArgumentError("quickActionID", msg).WithMeta(errGQLMetaKey, "INVALID_QUICK_ACTION_ID")
}
