package quickactions

import (
	pb "code.justin.tv/cb/dropship/rpc/dropship"
)

func GetDefaultLayout(isPartner bool, ownerID, channelID string) *pb.SetLayoutReq {
	defaults := GetDefaultNamesForNonPartners()
	if isPartner {
		defaults = GetDefaultNamesForPartners()
	}

	defaultItems := make([]*pb.Item, len(defaults))
	for i, d := range defaults {
		defaultItems[i] = &pb.Item{
			Type: "quick_action",
			ID:   d,
		}
	}

	return &pb.SetLayoutReq{
		OwnerID:   ownerID,
		ChannelID: channelID,
		Layout:    defaultItems,
	}
}
