package quickactions

import (
	"testing"
)

func TestQuickActionsDefaultLayoutPartner(t *testing.T) {
	partnerDefaultLayout := GetDefaultLayout(true, "010101", "some-channel")
	for _, entry := range partnerDefaultLayout.Layout {
		if _, found := defaultNamesPartner[entry.ID]; !found {
			t.Errorf("Expected Partner Layout to contain %s but it did not", entry.ID)
		}
	}
}

func TestQuickActionsDefaultLayoutNonPartner(t *testing.T) {
	nonPartnerDefaultLayout := GetDefaultLayout(false, "010101", "some-channel")
	for _, entry := range nonPartnerDefaultLayout.Layout {
		if _, found := defaultNamesNonPartner[entry.ID]; !found {
			t.Errorf("Expected non Partner Layout to contain %s but it did not", entry.ID)
		}
	}
}
