package util

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/credentials/ec2rolecreds"
	"github.com/aws/aws-sdk-go/aws/session"
)

// GetCredsForEC2 returns new credentials for use in an EC2 instance
func GetCredsForEC2(env, region string) *credentials.Credentials {
	if env == "development" {
		return credentials.NewSharedCredentials("", "twitch-cb-aws")
	}

	return ec2rolecreds.NewCredentials(
		session.New(&aws.Config{
			Region: aws.String(region),
		}),
	)
}
